﻿var addCode = {
    context: $(".v-add-code-to-question"),

    initialize: function () {
        $(".v-dynamicEditor", this.context).a4dynamicGrid({
            addRow: function (e, d) {
                $(".h-addRow", addCode.context).scrollIntoView($(".content", addCode.context), 30);
            },
            deleteRow: function (e, d) {
                $(".state", d.item).val("Deleted");
            }
        });

        addCode.context.on("change", ".v-code", function () {
            var code = $(this).val();
            var isExist = addCode.isCodeExist(code);
            
            if (isExist && code) {
                $(this).val("");
                a4.showErrorMessage(resources.DuplicateCode);
            }
            
        });

    },
    isCodeExist: function (code) {
        var codes = _.pluck($(".v-code"), "value");
        
        var count = _.countBy(codes, function (c) {
            return c == code ? "currentCode" : "others";
        });
        
        return count.currentCode > 1;
    }
};


$(document).ready(function () {
    if (addCode.context.length > 0) {
        addCode.initialize();
    }
});